% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Parameter Pendel
stPendel = ladePendel();

stTraj = berechneTrajektorie(stPendel, 1.2);
% Verflschen der Pendeldaten
stPendel.lPendel = stPendel.lPendel;
%stPendel.mPendel = 10*stPendel.mPendel;
%stPendel.g = 10;

% Anfangszustand Pendel (0 ist unten, pi oben)
x0 = [0 0 0 0].';

t = stTraj.vT;
u = stTraj.vU;
T = stTraj.T;

% Ausfhren Simulation, Simulationszeit wird in vT gespeichert
vT = sim('SteuerungPendel');


% =========================================================
% Verlufe plotten

vTGrenze = [0; T+1];
vPiGrenze = [1; 1] * pi;

% Ausgabe der Trajektorie Winkel
subplot (2, 1, 1);
plot(stTraj.vT, stTraj.mX(3,:), ':', vT, mStates(:, 3), 'b', ...
		vTGrenze, vPiGrenze, 'k');	
title('Trajektorie Winkel');
ylabel('x_3^*(t)/x_3(t) [rad]');
legend('x_3^*', 'x_3' , 'Location', 'SouthEast')

% Ausgabe der Trajektorie Winkelgeschwindigkeit
subplot (2, 1, 2);
plot(stTraj.vT, stTraj.mX(4,:), ':', vT, mStates(:, 4), 'b');
title('Trajektorie Winkelgeschwindigkeit');
ylabel('x_4^*(t)/x_4(t) [rad/s]');
legend('x_4^*', 'x_4' , 'Location', 'NorthEast')
xlabel('Zeit t [s]');


% =========================================================
% Animation abspielen
% (Das 5. Argument ist die Zeit zwischen zwei Bildern in
% Sekunden, das letzte ein "Schalter" zum Speichern der
% Einzelbilder.)
% mStates wird mit Simulink berechnet

animierePendel(vT, mStates, stPendel, [], 0.1, 0);



