% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

%% Versuch 2
% Aufgabe switch variable teil
% teil 1: Vergleich der Zustandsraummmodelle
% teil 2: Vergleich der Eigenwerte
% teil 3: Normalformen
% teil 4: Steuerbarkeit und Beobachtbarkeit
teil = 4;
AP = 0;
switch teil
    case 1
        clc

        %% Sechs Zustandsmodelle laden
        para

        %% unterer (stabiler) AP
        disp( 'unterer (stabiler) AP' );
        disp( 'smtliche Dmpfung enthalten' )
        [A1,B] = initLinear( l, mp, ms, Rs, Rp, g, 0 );
        B
        A1
        disp( 'keine Dmpfung im Gelenk' );
        [A2] = initLinear( l, mp, ms, Rs, 0, g, 0 );
        A2
        disp( 'gar keine Dmpfung' );
        [A3] = initLinear( l, mp, ms, 0, 0, g, 0 );
        A3


        %% oberer (instabiler) AP
        disp( 'oberer (instabiler) AP' );
        disp( 'smtliche Dmpfung enthalten' );
        [A1,B] = initLinear( l, mp, ms, Rs, Rp, g, pi );
        B
        A1
        disp( 'keine Dmpfung im Gelenk' );
        [A2] = initLinear( l, mp, ms, Rs, 0, g, pi );
        A2
        disp( 'gar keine Dmpfung' );
        [A3] = initLinear( l, mp, ms, 0, 0, g, pi );
        A3
    
    case 2
        clc

        %% Sechs Zustandsmodelle laden
        para

        %% unterer (stabiler) AP
        disp( 'unterer (stabiler) AP' );
        disp( 'smtliche Dmpfung enthalten' )
        A = initLinear( l, mp, ms, Rs, Rp, g, 0 );
        eig( A )
        disp( 'keine Dmpfung im Gelenk' );
        A = initLinear( l, mp, ms, Rs, 0, g, 0 );
        eig( A )
        disp( 'gar keine Dmpfung' );
        A = initLinear( l, mp, ms, 0, 0, g, 0 );
        eig( A )

        %% oberer (instabiler) AP
        disp( 'oberer (instabiler) AP' );
        disp( 'smtliche Dmpfung enthalten' )
        A = initLinear( l, mp, ms, Rs, Rp, g, pi );
        eig( A )
        disp( 'keine Dmpfung im Gelenk' );
        A = initLinear( l, mp, ms, Rs, 0, g, pi );
        eig( A )
        disp( 'gar keine Dmpfung' );
        A = initLinear( l, mp, ms, 0, 0, g, pi );
        eig( A )
    case 3
        clc;

        para

        %% oberer AP
        disp( 'oberer AP' );
        [A,B,C,D] = initLinear( l, mp, ms, Rs, Rp, g, pi );
        sys = ss( A, B, C, D );

        % Diagonalform
        disp( 'diagonalForm' );
        [AD, BD, CD, DD] = diagonalForm( A, B, C, D )

        disp( 'canon' );
        sysD = canon( sys, 'modal' );
        [AD, BD, CD, DD] = ssdata( sysD )

        %% unterer AP
        disp( 'unterer AP' );
        [A,B,C,D] = initLinear( l, mp, ms, Rs, Rp, g, 0 );    
        sys = ss( A, B, C, D );

        % Modalform
        disp( 'canon' );
        sysD = canon( sys, 'modal' );
        [AD, BD, CD, DD] = ssdata( sysD )
    case 4
        clc;

        para

        [A,B,C] = initLinear( l, mp, ms, 0, 0, g, AP);

        % Steuer- und Beobachtbarkeit nach Kalman
        checkCtrbKalman( A, B );


        checkObsvKalman( A, C );


        % Steuer- und Beobachtbarkeit nach Gilbert
        checkCtrbGilbert( A, B );
        checkObsvGilbert( A, C );

        % Steuer- und Beobachtbarkeit nach Hautus
        checkCtrbHautus( A, B );
        checkObsvHautus( A, C );
end
